//
//  CIImage+CRGraphics.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 6/16/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// CIImage category
//////////////////////////////////////////////////////////////////////
@interface CIImage (CRGraphics)

- (NSImage *)NSImage;
- (NSBitmapImageRep *)renderBitmap;
- (NSBitmapImageRep *)renderBitmapSoftwareMode:(BOOL)software;
- (void)forceRender;

+ (CIImage *)imageWithColor:(CIColor *)color extent:(CIVector *)extent;
+ (CIImage *)imageWithColor:(CIColor *)color extentRect:(NSRect)extent;
+ (CIImage *)imageWithColor:(CIColor *)color size:(NSSize)size;

+ (CIImage *)imageNamed:(NSString*)imageName;
+ (CIImage *)imageForSmartPath:(NSString *)path inBundle:(NSBundle *)bundle;

@end